<img src="https://r2cdn.perplexity.ai/pplx-full-logo-primary-dark%402x.png" style="height:64px;margin-right:32px"/>

# Что за мир в нюлевиле, который подписал наполеон?

Речь идёт о **Тильзитском мире** — мирном договоре, заключённом между российским императором Александром I и французским императором Наполеоном I Бонапартом 25 июня (7 июля) 1807 года в городе Тильзит (ныне Советск в Калининградской области). Договор завершил Войну четвёртой коалиции.[^1_6][^1_10]

## Обстоятельства подписания

Переговоры проводились на специально построенном плоту посередине реки Неман, где был установлен белый шатёр с буквой "N" со стороны Франции и буквой "A" со стороны России. После разгрома русской и прусской армий Александр I инициировал мирные переговоры, а Наполеон увидел в этом возможность укрепить свои позиции в Европе и изолировать Британию.[^1_8][^1_14]

## Основные условия

Главный секретный пункт договора предусматривал взаимную военную помощь между Россией и Францией во всякой наступательной и оборонительной войне. Александр I признавал все территориальные приобретения Наполеона в Европе, а взамен Наполеон предлагал России помощь в присоединении Финляндии и балканских владений Турции. Обе державы обязались заставить остальную Европю соблюдать континентальную блокаду против Англии.[^1_14][^1_6]

## Последствия

Непосредственным итогом стало решающее ослабление Пруссии, которая потеряла практически всю свою армию и была уменьшена почти наполовину. Тильзитский мир устранил единственного сильного континентального соперника Наполеона, оставив Англию в изоляции.[^1_6]
<span style="display:none">[^1_1][^1_11][^1_12][^1_13][^1_15][^1_2][^1_3][^1_4][^1_5][^1_7][^1_9]</span>

<div align="center">⁂</div>

[^1_1]: https://www.reddit.com/r/WarCollege/comments/11ji5zc/was_napoleon_bad_on_a_strategic_level/

[^1_2]: https://otvet.mail.ru/question/177342839

[^1_3]: https://en.wikipedia.org/wiki/War_and_Peace

[^1_4]: https://www.reddit.com/r/totalwar/comments/lq2krp/playing_napoleon_total_war_on_hard_difficulty_is/

[^1_5]: https://anime-characters-fight.fandom.com/ru/wiki/Наполеон_%D0%91%D0%BE%D0%BD%D0%B0%D0%BF%D0%B0%D1%80%D1%82

[^1_6]: https://ru.wikipedia.org/wiki/Тильзитский_%D0%BC%D0%B8%D1%80

[^1_7]: https://www.instagram.com/p/CgmXUjjsZFB/

[^1_8]: https://nasledie.pravda.ru/1814120-tilzitskii_mir/

[^1_9]: https://steamcommunity.com/sharedfiles/filedetails/?l=french\&id=643198079

[^1_10]: https://iwonder.city/ru/share/730_f22

[^1_11]: https://www.reddit.com/r/Napoleon/comments/1oj00o9/waterloo_directed_by_sergei_bondarchuk_premiered/

[^1_12]: https://ru.wikipedia.org/wiki/Кампо-Формийский_%D0%BC%D0%B8%D1%80

[^1_13]: https://www.youtube.com/watch?v=9xPKiYrBAZo

[^1_14]: https://vk.com/@heroes_of_history-tilzitskii-mir-kto-ego-narushil-pervyi-aleksandr-i-ili-napol

[^1_15]: https://www.louvre.fr/en/explore/visitor-trails/secret-treasures-of-the-richelieu-wing/from-palace-to-museum-the-minister-s-apartments


---

# Нет, какой-то другой мир, в 1801 году. Проверь

Вы, вероятно, имеете в виду **Люневильский мир** (Treaty of Lunéville), который был подписан 9 февраля 1801 года в городе Люневиль (Франция).[^2_1][^2_2]

Этот договор был заключён между Французской республикой и Австрией после разгрома австрийских войск армией Наполеона (особенно после битвы при Маренго).[^2_3][^2_4]

### Основные моменты:

* **Участники:** Со стороны Франции подпись поставил Жозеф Бонапарт (брат Наполеона), а со стороны Австрии — граф Людвиг фон Кобенцль.[^2_2][^2_3]
* **Итоги:**
    * Австрия была вынуждена выйти из Второй антифранцузской коалиции, что привело к её распаду.[^2_5]
    * Франция закрепила за собой левый берег Рейна, а также контроль над Бельгией и Люксембургом.[^2_1]
    * Австрия признала дочерние республики Франции (Батавскую, Гельветическую, Цизальпинскую и Лигурийскую).[^2_6]

По сути, этот мир подтвердил и расширил условия предыдущего, Кампо-Формийского мира, закрепив доминирование Наполеона в Италии и Германии.[^2_3]
<span style="display:none">[^2_10][^2_11][^2_12][^2_13][^2_14][^2_15][^2_7][^2_8][^2_9]</span>

<div align="center">⁂</div>

[^2_1]: https://ru.wikipedia.org/wiki/Люневильский_%D0%BC%D0%B8%D1%80

[^2_2]: https://ru.ruwiki.ru/wiki/Люневильский_%D0%BC%D0%B8%D1%80

[^2_3]: https://w.histrf.ru/articles/lyunevilskiy-mir-1801

[^2_4]: https://all-russia-history.ru/treaty-of-luneville

[^2_5]: https://www.hrono.ru/dokum/1800dok/1801lyunevil.php

[^2_6]: https://runivers.ru/runivers_articles/?ELEMENT_ID=640613

[^2_7]: https://ru.wikipedia.org/wiki/Парижский_%D0%BC%D0%B8%D1%80%D0%BD%D1%8B%D0%B9_%D0%B4%D0%BE%D0%B3%D0%BE%D0%B2%D0%BE%D1%80_(1801)

[^2_8]: https://www.youtube.com/watch?v=3ysGHgQgQrU

[^2_9]: https://ru.wikipedia.org/wiki/Наполеоновские_%D0%B2%D0%BE%D0%B9%D0%BD%D1%8B

[^2_10]: https://old.bigenc.ru/world_history/text/2162664

[^2_11]: https://runivers.ru/lib/anons.php?ID=62283\&IBLOCK_ID=33

[^2_12]: https://history.wikireading.ru/hlotVZfL8m

[^2_13]: https://www.booksite.ru/fulltext/1/001/008/072/073.htm

[^2_14]: https://www.1812w.ru/dokum/1800dok/1801lyunevil.php

[^2_15]: https://www.youtube.com/watch?v=RrIKl_E2PdM


---

# А впоследствии те территории, которые получила Франция, она потеряла?

Да, большинство территорий, приобретённых Францией по Люневильскому миру 1801 года, были утеряны после окончательного поражения Наполеона.

### 1. Левый берег Рейна и Бельгия

Одной из ключевых уступок Австрии в 1801 году был переход левого берега Рейна и Бельгии под контроль Франции.[^3_1][^3_4]

* **Итог:** После разгрома Наполеона эти земли были отторгнуты от Франции. Венский конгресс 1815 года восстановил границы, близкие к тем, что существовали до революционных войн. Бельгия вошла в состав Нидерландов (позже стала независимой), а рейнские земли отошли Пруссии и Баварии.[^3_6]


### 2. Дочерние республики

Договор закрепил контроль Франции над «дочерними республиками» — Батавской (Нидерланды), Гельветической (Швейцария), Цизальпинской и Лигурийской (Италия).[^3_4][^3_11]

* **Итог:** С падением Империи Наполеона эта система вассальных государств рухнула. Италия и Германия были перекроены, их прежние правители или новые династии вернули власть, а прямое французское управление было ликвидировано.[^3_6]


### 3. Луизиана (косвенная потеря)

Хотя это не прямой результат Люневильского мира, но в тот же период Наполеон понял, что не сможет удержать заморские владения в условиях новой войны с Англией. В 1803 году он продал огромную территорию Луизианы Соединённым Штатам, окончательно отказавшись от планов колониальной империи в Северной Америке.[^3_9]

Таким образом, территориальные приобретения, сделавшие Францию доминирующей силой в Европе в начале XIX века, были практически полностью аннулированы Венским конгрессом в 1815 году. Границы Франции вернулись к состоянию 1790 года.[^3_6]
<span style="display:none">[^3_10][^3_2][^3_3][^3_5][^3_7][^3_8]</span>

<div align="center">⁂</div>

[^3_1]: https://ru.wikipedia.org/wiki/Люневильский_%D0%BC%D0%B8%D1%80

[^3_2]: https://www.reddit.com/r/AskHistorians/comments/1rvs7w/how_did_france_after_ww2_manage_to_impose_itself/

[^3_3]: https://ru.wikipedia.org/wiki/Война_%D0%B2%D1%82%D0%BE%D1%80%D0%BE%D0%B9_%D0%BA%D0%BE%D0%B0%D0%BB%D0%B8%D1%86%D0%B8%D0%B8

[^3_4]: https://all-russia-history.ru/treaty-of-luneville

[^3_5]: https://piter.tv/event/Politolog_Stankevich_napomnil_Francii_o_potere_territorij_voennim_putem/

[^3_6]: https://ru.ruwiki.ru/wiki/История_%D0%A4%D1%80%D0%B0%D0%BD%D1%86%D0%B8%D0%B8_(1789%E2%80%941914)

[^3_7]: https://www.mn.ru/smart/konecz-epohi-kak-francziya-poteryala-vliyanie-v-afrike-i-kto-pridet-ej-na-smenu

[^3_8]: https://news.rambler.ru/world/55163299-frantsii-napomnili-o-potere-territoriy-voennym-putem/

[^3_9]: https://www.booksite.ru/localtxt/tar/le/tarle/nap/ole/napoleon/6.htm

[^3_10]: https://studfile.net/preview/21635916/page:2/

[^3_11]: https://w.histrf.ru/articles/lyunevilskiy-mir-1801


---

```
# <q>он продал огромную территорию Луизианы Соединённым Штатам</q> Это что и где находится? Сейчас под чьим контролем, какой страны?
```

**Луизианская покупка** (1803 год) — это сделка, в ходе которой США приобрели у Франции огромную территорию в Северной Америке. Это не просто современный штат Луизиана, а гораздо более обширные земли.[^4_1][^4_2]

### Где это находится?

Территория простиралась от реки Миссисипи на востоке до Скалистых гор на западе и от Мексиканского залива на юге до границы с нынешней Канадой на севере.[^4_3][^4_1]

В современных границах эта территория полностью или частично охватывает **15 штатов США** и две провинции Канады:[^4_4][^4_1]

* **Целиком:** Арканзас, Миссури, Айова, Оклахома, Канзас, Небраска.
* **Значительные части:** Южная Дакота, Северная Дакота, Монтана, Вайоминг, Миннесота, Луизиана (обе стороны Миссисипи).
* **Частично:** Нью-Мексико, Техас, Колорадо.


### Под чьим контролем сейчас?

Сегодня эти земли находятся под полным суверенитетом **Соединённых Штатов Америки**. Небольшие северные участки, купленные в 1803 году, позже отошли Великобритании (сейчас это часть канадских провинций Альберта и Саскачеван) в результате уточнения границ в 1818 году.[^4_5][^4_1]

### Почему Наполеон её продал?

Наполеон понял, что не сможет защитить эти отдалённые владения в случае неминуемой войны с Великобританией (у которой был мощный флот). Чтобы не потерять колонию бесплатно в ходе войны, он решил продать её США за 15 миллионов долларов (около 7 центов за гектар), тем самым пополнив казну и укрепив США как противовес Британии.[^4_6][^4_7]
<span style="display:none">[^4_10][^4_11][^4_12][^4_13][^4_14][^4_15][^4_8][^4_9]</span>

<div align="center">⁂</div>

[^4_1]: https://ru.wikipedia.org/wiki/Луизианская_%D0%BF%D0%BE%D0%BA%D1%83%D0%BF%D0%BA%D0%B0

[^4_2]: https://usa-info.com.ua/history/luizianskaya.html

[^4_3]: https://ru.ruwiki.ru/wiki/Луизианская_%D0%BF%D0%BE%D0%BA%D1%83%D0%BF%D0%BA%D0%B0

[^4_4]: http://iobninsk.ru/louisiana-purchase/

[^4_5]: https://www.ronl.org/kontrolnyye-raboty/istoriya/786989/

[^4_6]: https://finkalendar.ru/articles/podpisan-dogovor-o-pokupke-luiziany/

[^4_7]: https://www.alphapedia.ru/w/Louisiana_Purchase

[^4_8]: https://dic.academic.ru/dic.nsf/ruwiki/83390

[^4_9]: https://pikabu.ru/story/do_1803_goda_chetvert_territorii_ssha_prinadlezhala_frantsii_2084514

[^4_10]: https://ru.wikipedia.org/wiki/История_%D0%9B%D1%83%D0%B8%D0%B7%D0%B8%D0%B0%D0%BD%D1%8B

[^4_11]: https://pikabu.ru/story/luizianskaya_pokupka_kak_ssha_kupili_polkontinenta_za_kopeyki_i_kto_realno_proigral_12599016

[^4_12]: https://america-xix.ru/library/louisiana-purchase-1803/

[^4_13]: https://ru.wikipedia.org/wiki/Территория_%D0%9B%D1%83%D0%B8%D0%B7%D0%B8%D0%B0%D0%BD%D0%B0

[^4_14]: https://www.sovsekretno.ru/articles/istoriya/pervyy-konsul-frantsii-prodal-ispaniyu-/

[^4_15]: https://america-xix.ru/great-migration/louisiana.html


---

# А каким образом вообще Франция завладела теми территориями?

Франция «завладела» Луизианой в первую очередь через **колониальные притязания**: экспедиции, провозглашение территории владением французской короны и последующее создание колонии в бассейне Миссисипи.[^5_1][^5_2]

## Первое присвоение (XVII век)

В 1682 году исследователь Рене-Робер Кавелье де Ла Саль объявил земли в бассейне реки Миссисипи владением французского короля и назвал эту область «Луизиана» в честь Людовика XIV.[^5_2][^5_1]
После этого Франция рассматривала регион как часть своей североамериканской колониальной системы (Новая Франция), закрепляя присутствие поселениями и администрацией вдоль Миссисипи.[^5_1]

## Потеря в пользу Испании (1762–1763)

Во время Семилетней войны Франция, чтобы компенсировать потери союзной Испании, по секретному договору в Фонтенбло (1762) уступила Испании Французскую Луизиану.[^5_3]
Параллельно Парижский мир 1763 года перераспределил североамериканские владения, и Луизиана перестала быть устойчивой французской территорией в прежнем виде.[^5_4][^5_3]

## Возвращение Франции перед продажей (1800–1803)

В 1800 году по договору в Сан-Ильдефонсо Испания согласилась вернуть Луизиану Франции (соглашение было тайным).[^5_5][^5_6]
Фактическая передача контроля от Испании к Франции была завершена 30 ноября 1803 года — буквально за несколько недель до продажи США.[^5_6]

## Важно про термин «Луизиана»

«Французская Луизиана» тогда означала огромный регион в центре Северной Америки (вокруг бассейна Миссисипи), а не только современный штат Луизиана.[^5_6][^5_1]

Если нужно, можно уточнить: интересует юридическая логика «права открытия» (как это понимали европейские державы) или конкретные французские поселения/административные шаги, которыми они закрепляли контроль?
<span style="display:none">[^5_10][^5_11][^5_12][^5_13][^5_14][^5_15][^5_7][^5_8][^5_9]</span>

<div align="center">⁂</div>

[^5_1]: https://ru.wikipedia.org/wiki/История_%D0%9B%D1%83%D0%B8%D0%B7%D0%B8%D0%B0%D0%BD%D1%8B

[^5_2]: https://america-xix.ru/library/lutskov-louisiana/

[^5_3]: https://ru.wikipedia.org/wiki/Договор_%D0%B2_%D0%A4%D0%BE%D0%BD%D1%82%D0%B5%D0%BD%D0%B1%D0%BB%D0%BE_(1762)

[^5_4]: https://old.bigenc.ru/world_history/text/2320906

[^5_5]: https://ru.wikipedia.org/wiki/Договор_%D0%B2_%D0%A1%D0%B0%D0%BD-%D0%98%D0%BB%D1%8C%D0%B4%D0%B5%D1%84%D0%BE%D0%BD%D1%81%D0%BE_(1800)

[^5_6]: https://ru.wikipedia.org/wiki/Луизианская_%D0%BF%D0%BE%D0%BA%D1%83%D0%BF%D0%BA%D0%B0

[^5_7]: https://ru.wikipedia.org/wiki/Французская_%D0%BA%D0%BE%D0%BB%D0%BE%D0%BD%D0%B8%D0%B7%D0%B0%D1%86%D0%B8%D1%8F_%D0%A2%D0%B5%D1%85%D0%B0%D1%81%D0%B0

[^5_8]: https://www.calend.ru/events/4953/

[^5_9]: https://ru.ruwiki.ru/wiki/История_%D0%9B%D1%83%D0%B8%D0%B7%D0%B8%D0%B0%D0%BD%D1%8B

[^5_10]: http://hrono.ru/biograf/bio_r/rene_rober.html

[^5_11]: https://kpfu.ru/portal/docs/F448896890/150_7_gum_20.pdf

[^5_12]: https://ru.ruwiki.ru/wiki/Луизиана_(%D0%9D%D0%BE%D0%B2%D0%B0%D1%8F_%D0%98%D1%81%D0%BF%D0%B0%D0%BD%D0%B8%D1%8F)

[^5_13]: https://www.stena.ee/blog/“luizianskaya-pokupka”-1803-goda-cdelka-izmenivshaya-istoriyu-soedinyonnyh-shtatov

[^5_14]: https://ushistory.ru/index.php/populjarnaja-literatura/1182-la-sal-drug-indejtsev

[^5_15]: https://en.wikipedia.org/wiki/Treaty_of_Fontainebleau_(1762)


---

## Гренландия

- **~985–1000:** Норвежский викинг Эрик Рыжий основал первые скандинавские поселения[^6_1][^6_2]
- **1261:** Гренландия присягнула на верность норвежскому королю и стала платить ему налоги[^6_3]
- **~1400:** Норвежские поселения викингов исчезли из-за похолодания климата, но остров продолжал формально считаться норвежским[^6_4]
- **1536:** Создание единого датско-норвежского государства с доминированием Дании; Гренландия формально перешла под власть датского короля[^6_3]
- **1814:** Распад датско-норвежской унии; Гренландия окончательно осталась за Данией[^6_4]
- **1979:** Гренландия получила автономию в составе Дании[^6_5]
- **2026 (январь):** Президент США Трамп и генсек НАТО Марк Рютте объявили о согласовании рамочных условий сделки по Гренландии; Трамп потребовал немедленных переговоров о покупке острова у Дании[^6_6][^6_7]


## США

- **До XVII века:** Территории населяли коренные народы[^6_8]
- **1607–1733:** Великобритания основала 13 колоний на восточном побережье[^6_8]
- **1763:** По Парижскому миру Британия получила Канаду и восточную часть Луизианы до Миссисипи[^6_8]
- **1776:** Декларация независимости 13 колоний[^6_8]
- **1783:** Парижский договор признал независимость США; Испания получила Флориду[^6_8]
- **1803:** Луизианская покупка у Франции — удвоение территории США (центральная часть континента)[^6_9][^6_10]
- **1819:** Испания передала Флориду США[^6_8]
- **1845–1898:** Дальнейшая экспансия на запад (Техас, территории после войны с Мексикой, Аляска у России в 1867, Гавайи)
<span style="display:none">[^6_11]</span>

<div align="center">⁂</div>

[^6_1]: https://ru.wikipedia.org/wiki/История_%D0%93%D1%80%D0%B5%D0%BD%D0%BB%D0%B0%D0%BD%D0%B4%D0%B8%D0%B8

[^6_2]: https://globhistory.org/ru/article/norvegiya/kolonizaciya_grenlandii_norvegiey

[^6_3]: https://goarctic.ru/news/ot-vikingov-do-inuitov-istoriya-grenlandii/

[^6_4]: https://poisknews.ru/geologiya/ostrov-pretknoveniya-radi-chego-delyat-grenlandiyu-daniya-i-ssha/

[^6_5]: https://ru.wikipedia.org/wiki/Хронология_%D0%B8%D1%81%D1%82%D0%BE%D1%80%D0%B8%D0%B8_%D0%93%D1%80%D0%B5%D0%BD%D0%BB%D0%B0%D0%BD%D0%B4%D0%B8%D0%B8

[^6_6]: https://expert.ru/news/donald-tramp-prizval-k-nemedlennym-peregovoram-o-pokupke-grenlandii-ssha/

[^6_7]: https://www.dw.com/ru/tramp-obavil-o-sdelke-po-grenlandii-i-otmenil-vvod-poslin/a-75598966

[^6_8]: https://ru.wikipedia.org/wiki/Тринадцать_%D0%BA%D0%BE%D0%BB%D0%BE%D0%BD%D0%B8%D0%B9

[^6_9]: https://america-xix.ru/library/gonionskiy-us-expansion/

[^6_10]: https://ru.wikipedia.org/wiki/Луизианская_%D0%BF%D0%BE%D0%BA%D1%83%D0%BF%D0%BA%D0%B0

[^6_11]: https://ria.ru/20190206/1550497099.html


---

## Целесообразность сделки (для Наполеона)

Продажа была **в высшей степени прагматичным решением**. В 1803 году Франция не имела ресурсов удерживать эту территорию.

1. **Потеря опорной базы:** Главной ценностью для Франции в регионе был остров Санто-Доминго (Гаити), богатый сахаром. Луизиана рассматривалась лишь как продовольственная база для снабжения карибских плантаций. После провала экспедиции и успеха Гаитянской революции (где французский экспедиционный корпус погиб от желтой лихорадки и сопротивления бывших рабов) стратегический смысл владения Луизианой исчез.[^7_1][^7_2]
2. **Угроза войны:** Назревала новая война с Великобританией. У Британии был мощнейший флот, а французская Луизиана была практически не защищена. Наполеон понимал, что англичане могут захватить её бесплатно в первые же месяцы войны. Продажа позволяла получить хоть что-то за территорию, которую всё равно было бы невозможно удержать.[^7_2]
3. **Геополитика:** Усиливая США, Наполеон создавал долгосрочного морского соперника для Британии, рассчитывая, что Америка рано или поздно бросит вызов английскому доминированию на морях.[^7_3]

## Оценка цены

Сделка составила **15 миллионов долларов** (около 3-4 центов за акр).[^7_4][^7_5]

* **Для США:** Это была феноменально низкая цена ("сделка века"). Томас Джефферсон рассчитывал купить только Новый Орлеан за 10 млн, а получил территорию, удвоившую размер страны, всего за 15 млн. Даже с учетом процентов по кредитам (итоговая сумма выросла до ~23 млн к 1823 году), это было сверхвыгодно.[^7_5][^7_6][^7_3][^7_4]
* **Для Франции:** Цена была низкой в пересчете на акр, но это была крупная единовременная выплата за "бесполезные" джунгли и прерии, которые фактически не контролировались. Наполеон получил живые деньги здесь и сейчас.[^7_7]


## Куда пошли деньги?

Деньги поступили во французскую казну, но с нюансами:

1. **Структура выплаты:** Из 15 млн долларов Франция получила "живыми деньгами" только около **11,25 млн**. Оставшиеся **3,75 млн** (20 млн франков) США обязались выплатить собственным гражданам в счет погашения долгов Франции (компенсации за захваченные французскими корсарами американские суда).[^7_4][^7_5]
2. **Траты:** Средства были немедленно направлены на **подготовку к войне с Великобританией**. В частности, они пошли на финансирование армии и строительство флота для планируемого вторжения в Англию (знаменитый Булонский лагерь), а также на покрытие дефицита бюджета.[^7_6][^7_1]

## Статус коренных народов в 1803 году

Это критически важный момент: **Франция продала не землю как недвижимость, а "право на суверенитет"**.

* **Реальный контроль:** В 1803 году европейские поселенцы (французы и испанцы) контролировали лишь крошечную часть территории — в основном Новый Орлеан, Сент-Луис и несколько фортов вдоль реки Миссисипи. Вся остальная огромная территория (более 90-95%) находилась под полным контролем индейских племен (сиу, шайенны, оседжи, команчи и др.).[^7_8]
* **Вытеснение:** На момент продажи масштабного вытеснения коренных народов с этих земель еще не было. США фактически купили у Наполеона "эксклюзивное право" договариваться с индейцами или завоевывать их, не опасаясь вмешательства других европейских держав. Реальный процесс отъема земель, войн и переселения индейцев в этом регионе начался значительно позже и растянулся на весь XIX век.[^7_8]
<span style="display:none">[^7_10][^7_11][^7_12][^7_13][^7_14][^7_15][^7_9]</span>

<div align="center">⁂</div>

[^7_1]: https://www.reddit.com/r/history/comments/7rmzv6/why_did_france_sell_the_louisiana_territory_to/

[^7_2]: https://www.reddit.com/r/history/comments/5s7d0l/what_were_napoleons_motives_behind_selling_the/

[^7_3]: https://ru.wikipedia.org/wiki/История_%D0%9B%D1%83%D0%B8%D0%B7%D0%B8%D0%B0%D0%BD%D1%8B

[^7_4]: https://ru.wikipedia.org/wiki/Луизианская_%D0%BF%D0%BE%D0%BA%D1%83%D0%BF%D0%BA%D0%B0

[^7_5]: https://www.pnp.ru/in-world/napoleon-prodal-luizianu-za-23-mln-dollarov.html

[^7_6]: https://vk.com/@history_repeats-ssha-kupili-u-francii-tret-strany

[^7_7]: https://www.reddit.com/r/explainlikeimfive/comments/4di0yh/eli5_why_was_the_louisiana_puschase_so_cheap_and/

[^7_8]: https://www.stena.ee/blog/“luizianskaya-pokupka”-1803-goda-cdelka-izmenivshaya-istoriyu-soedinyonnyh-shtatov

[^7_9]: https://america-xix.ru/library/lutskov-louisiana/

[^7_10]: https://chispa1707.ussr.win/908

[^7_11]: https://cyberleninka.ru/article/n/harakter-amerikano-frantsuzskih-otnosheniy-v-nachale-xix-veka-istoricheskoe-nasledie-luizianskoy-sdelki

[^7_12]: https://america-xix.ru/great-migration/louisiana.html

[^7_13]: https://www.reddit.com/r/AskHistorians/comments/3elkru/was_the_louisiana_purchase_really_considered/

[^7_14]: https://www.facebook.com/gmrashid/posts/222-года-назад-в-октябре-сша-стали-одной-из-держав-первого-ранга-в-мире-а-франци/10161709215660840/

[^7_15]: https://www.reddit.com/r/AskHistorians/comments/66mjse/when_the_united_states_acquired_louisiana/


---

## Методы выселения: от манипуляций до военного насилия

### Принудительные методы (1830–1850)

**Индийский акт о выселении (1830)** формально давал президенту право «договариваться», но на практике применялись системные принудительные методы:[^8_1][^8_2]

1. **Экономический шантаж:** Торговые посты правительства выдавали индейцам кредиты, которые они не могли вернуть, а затем требовали землю в счет долгов.[^8_3]
2. **Создание искусственного голода:** Армия захватывала индейские деревни, удерживала людей в концентрационных лагерях (называемых «лагерями сбора») без адекватных запасов продовольствия и воды.[^8_4][^8_5]
3. **Военное насилие:** 7 000 солдат под командованием генерала Винфилда Скотта в 1838 году вторглись в территорию чероки, сожгли дома, убивали сопротивляющихся и маркировали семьи номерами.[^8_6][^8_5]
4. **Обман и поддельные договоры:** «Договор Новой Экоты» (1835) был подписан незаконно неуполномоченной фракцией чероки без согласия основного населения.[^8_7]

### Согласие?

**Формальное согласие отсутствовало.** Верховный суд в деле *Ворчестер v. Джорджия* (1832) признал чероки суверенной нацией, а законы Джорджии о захвате их земель — неконституционными. Президент Эндрю Джексон проигнорировал решение суда, заявив: «Что решит Верховный суд, пусть сам его и исполняет». Это позволило штатам и федеральным агентам действовать вопреки праву.[^8_8][^8_9][^8_7]

## Умолчания и искажения в учебниках: анализ академических источников

### Системные проблемы (независимые исследования)

Исследование Университета Пенсильвания (2020) показало, что **87% материалов о коренных народах в школьных программах США ограничиваются периодом до 1900 года**, игнорируя современные вызовы (права на землю, водные ресурсы, договоры).[^8_10][^8_11]

**27 штатов вообще не упоминают коренных американцев в стандартах исторической программы**.[^8_10]

### Характер искажений

1. **Оmission (умолчание):** Термин «геноцид» практически не используется. Вместо этого применяются эвфемизмы: «переселение», «конфликты», «потери».[^8_12][^8_13]
2. **Фальсификация причин:** Учебники часто представляют выселение как «неизбежное» для «защиты» индейцев от белых поселенцев, перекладывая вину на отдельных «плохих поселенцев», а не на государственную политику.[^8_13]
3. **Героизация виновных:** Эндрю Джексон изображается как «сильный лидер», а не как автор политики, приведшей к тысячам смертей.[^8_13]
4. **Игнорирование сопротивления:** Активное сопротивление семинолов во Флориде (война 1835–1842) и других племен не упоминается, создавая впечатление пассивного подчинения.[^8_5][^8_13]

## Эффективность методов: с точки зрения США

**Методы были чрезвычайно эффективны в достижении целей:**

* **К 1850 году** около 88 000 коренных жителей восточной части США были насильственно переселены за Миссисипи.[^8_14]
* **Более 25%** чероки погибло в пути (по оценкам, до 4 000 из 15 500).[^8_9][^8_5]
* **Земли** (более 100 млн акров) были открыты для белых поселенцев и рабовладельческих плантаций.[^8_15][^8_14]

Однако с **гуманитарной точки зрения** методы были катастрофичны: концентрационные лагеря, эпидемии, голод, массовые убийства составляют этническую чистку, квалифицируемую ООН как преступление против человечности.[^8_16][^8_17]

## Ответственность: не только президент

**Системная ответственность** лежит на нескольких уровнях:

1. **Президенты:** Эндрю Джексон (подписал акт, игнорировал Верховный суд) и Мартин Ван Бюрен (активно реализовал выселение).[^8_18][^8_7]
2. **Конгресс:** Принял Закон о выселении узким большинством (под давлением южных штатов, требовавших земли).[^8_2][^8_1]
3. **Государственные правительства:** Джорджия, Алабама, Теннесси принимали законы, аннулирующие договоры и узурпирующие индейские земли.[^8_19][^8_7]
4. **Местные агенты и армия:** Федеральные агенты по делам индейцев подкупали вождей, а армия под генералом Скоттом проводила насильственное выселение.[^8_20][^8_6]
5. **Судебная система:** Хотя Верховный суд встал на сторону индейцев, решение не исполнялось, демонстрируя, что даже конституционное право было бессильно против политической воли.[^8_8][^8_9]

**Вывод:** Это была **государственная политика на всех уровнях** — федеральном, штатском и местном, с активным участием исполнительной, законодательной и (пассивной) судебной власти.
<span style="display:none">[^8_21][^8_22][^8_23][^8_24][^8_25][^8_26][^8_27][^8_28][^8_29][^8_30][^8_31][^8_32][^8_33][^8_34][^8_35][^8_36][^8_37][^8_38][^8_39][^8_40]</span>

<div align="center">⁂</div>

[^8_1]: https://en.wikipedia.org/wiki/Indian_Removal_Act

[^8_2]: https://constitutioncenter.org/the-constitution/historic-document-library/detail/indian-removal-act-1830 

[^8_3]: https://waseyabek.com/1830-the-indian-removal-act/

[^8_4]: https://www.britannica.com/story/trail-of-tears-routes

[^8_5]: https://en.wikipedia.org/wiki/Cherokee_removal

[^8_6]: https://digitalcommons.usf.edu/cgi/viewcontent.cgi?article=1188\&context=honorstheses

[^8_7]: https://www.georgiaencyclopedia.org/articles/government-politics/worcester-v-georgia-1832/

[^8_8]: https://www.ebsco.com/research-starters/law/worcester-v-georgia

[^8_9]: https://www.britannica.com/topic/Worcester-v-Georgia

[^8_10]: https://yipinstitute.org/capstone/incorporating-native-american-history

[^8_11]: https://digitalcommons.law.seattleu.edu/cgi/viewcontent.cgi?article=1042\&context=ailj

[^8_12]: https://rethinkingschools.org/articles/lies-our-textbooks-tell-us/

[^8_13]: https://www.reddit.com/r/NoStupidQuestions/comments/1gmocsg/is_it_true_that_in_some_states_they_dont_teach/

[^8_14]: https://www.neh.gov/article/trails-tears-plural-what-we-dont-know-about-indian-removal

[^8_15]: https://www.academia.edu/80604738/Reclaiming_social_justice_and_human_rights_The1830_Indian_Removal_Act_and_the_ethnic_cleansing_of_Native_American_tribes

[^8_16]: https://en.wikipedia.org/wiki/Trail_of_Tears

[^8_17]: https://digitalcommons.unl.edu/cgi/viewcontent.cgi?article=1001\&context=historydiss

[^8_18]: https://www.reddit.com/r/USHistory/comments/18o348p/who_did_the_most_enforcement_of_the_1830_indian/

[^8_19]: https://www.todayingeorgiahistory.org/tih-georgia-day/worcester-v-georgia/

[^8_20]: https://trace.tennessee.edu/cgi/viewcontent.cgi?article=2642\&context=utk_graddiss

[^8_21]: https://jfklaw.ca/landmark-scotus-decisions-confirms-that-eastern-oklahoma-rests-on-treaty-reservations-if-congress-wishes-to-break-the-promise-of-a-reservation-it-must-say-so/

[^8_22]: https://www.ebsco.com/research-starters/history/trail-tears

[^8_23]: https://www.zinnedproject.org/news/tdih/supreme-court-affirms-native-treaty-rights/

[^8_24]: https://news.yale.edu/2023/05/02/book-unmakes-us-history-include-long-excluded-native-americans

[^8_25]: https://www.supremecourt.gov/opinions/19pdf/18-9526_9okb.pdf

[^8_26]: https://library.oapen.org/bitstream/id/01042e63-f305-478c-8d2d-90607d1122a6/978-3-031-50353-5.pdf

[^8_27]: https://en.wikipedia.org/wiki/Worcester_v._Georgia

[^8_28]: https://www.zinnedproject.org/materials/why-you-cant-teach-us-history-without-american-indians/

[^8_29]: https://jhhe.sempervifoundation.org/pdfs/v7n1/02_Michael.pdf

[^8_30]: https://www.reddit.com/r/AskHistorians/comments/6kywre/monday_methods_american_indian_genocide_denial/

[^8_31]: https://losangeles.china-consulate.gov.cn/eng/topnews/202203/t20220302_10647120.htm

[^8_32]: https://immigrationhistory.org/item/1830-indian-removal-act/

[^8_33]: https://www.tandfonline.com/doi/full/10.1080/2201473X.2024.2358697

[^8_34]: https://pmc.ncbi.nlm.nih.gov/articles/PMC10688593/

[^8_35]: https://thekeep.eiu.edu/cgi/viewcontent.cgi?article=1034\&context=the_councilor

[^8_36]: https://constitutioncenter.org/the-constitution/historic-document-library/detail/indian-removal-act-1830

[^8_37]: https://www.brainwareuniversity.ac.in/brainwave/vol-5-issue-2-june-2024/1_MSA-24022024_Final_714-725.pdf

[^8_38]: https://digitalcommons.usf.edu/gsp/vol15/iss3/15/

[^8_39]: https://www.okhistory.org/publications/enc/entry?entry=IN015

[^8_40]: https://spssi.onlinelibrary.wiley.com/doi/10.1111/sipr.12105


---

### Введение

Разные штаты США по‑разному пишут и преподают историю, но есть общий рынок массовых учебников и общие тенденции. С 2000 по 2026 год картина такая: академическая историография уже достаточно откровенно описывает политику США по отношению к коренным народам как колониальную, часто — как геноцидную, тогда как школьные учебники и стандарты двигаются в эту сторону гораздо медленнее, с сильным политическим сопротивлением и заметными зонами умолчаний.[^9_1][^9_2][^9_3]

Ниже — по шагам: кто пишет и заказывает учебники, как в них описаны выселения индейцев, какая есть независимая критика и какова итоговая оценка того, насколько США в 2026 году берут на себя ответственность за этот период и учат детей «чтобы такое больше не повторилось».

***

## 1. Кто пишет и заказывает школьные учебники истории (2000–2026)

### Крупные издательства и авторы

Рынок школьных учебников истории в США с 2000‑х до наших дней контролируется несколькими гигантами:

- **McGraw‑Hill**,
- **Pearson** (ныне Savvas K–12 Learning),
- **Houghton Mifflin Harcourt (HMH)** и др..[^9_4][^9_5]

Для старших классов широко используются линейки:

- *American History* (HMH Social Studies),
- *United States History* (Pearson — Lapsansky‑Werner, Levy, Roberts, Taylor),[^9_5]
- *United States History and Geography* (McGraw‑Hill),[^9_5]
- для AP‑курсов и колледжей — *The Unfinished Nation* Алана Бринкли и соавторов (McGraw‑Hill), *America’s History* и др..[^9_6][^9_5]

Состав авторов, как правило, включает уважаемых академиков: например, в учебных материалах McGraw‑Hill по истории США среди авторов — Джеймс Макферсон (Принстон), известный историк Гражданской войны. Это важно: академическое сообщество зачастую гораздо честнее в научных публикациях, чем позволяет себе массовый школьный учебник.[^9_7][^9_8]

### Кто «заказывает музыку»

Формально:

- **Учебники пишут частные издательства**, ориентируясь на рынок.
- **Федерального единого стандарта по истории нет** — каждая из 50 штатов имеет свои «академические стандарты» по обществознанию и истории.
- Крупнейшее влияние на содержание оказывают **штатные советы по образованию** — прежде всего **Texas State Board of Education (SBOE)** и совет штата Калифорния. Одобрение в Техасе практически гарантирует огромный тираж по всей стране, поэтому издатели подстраиваются под политические требования этих советов.[^9_9][^9_10][^9_11][^9_5]

В Техасе тот же SBOE:

- утверждает или отклоняет конкретные учебники,
- влияет на то, какие темы и в каком тоне могут быть включены.

Пример: попытки внедрить курсы этнической истории (мексикано‑американской, афро‑американской, а затем и Native American Studies) сталкивались с серьёзным сопротивлением консервативного большинства совета.[^9_10][^9_12][^9_9]

То есть **«заказчиком» в практическом смысле являются не федеральные органы, а политически избираемые/назначаемые советы штатов и школьные округа**, которые определяют, какие учебники допускаются в школы и на каких условиях.[^9_11][^9_9][^9_10]

***

## 2. Как учебники 2000–2026 годов описывают выселение и уничтожение коренных народов

### Объём и расположение материала

Крупные независимые исследования стандартов и учебников показывают систематическую **«омиссию»** (умолчание) и сжатие истории коренных народов:

- Анализ стандартов 50 штатов показал, что **87% упоминаний коренных народов относятся к периоду до 1900 года**, а современная история и продолжающиеся последствия колониализма почти не рассматриваются.[^9_1]
- Книга *Misrepresentation and Silence in United States History Textbooks* (OAPEN) документирует, как коренные и мексикано‑американские общины «выметаются» на периферию рассказа об истории США — либо сведены к нескольким эпизодам «ранних контактов», либо показаны как фон для прогресса белых переселенцев.[^9_3]

Критическое кейс‑исследование пяти популярных школьных учебников, отобранных для крупного округа во Флориде (adoption 2012), показало:

- объём информации о коренных народах крайне мал,
- большая часть сосредоточена в главах про «открытие Америки» и «освоение фронтира»,
- в главах о XIX веке акцент смещён на развитие США, а индейские судьбы описаны коротко и функционально — как «препятствие» экспансии.[^9_2]


### Терминология и рамка интерпретации

Характерный набор приёмов:

1. **Эвфемизмы**
Политика насильственного выселения, по сути этнической чистки (Indian Removal, Trail of Tears), подаётся как «переселение на новые земли» или «часть политики освоения Запада».[^9_2]
Термины «геноцид», «колониализм», «этническая чистка» либо отсутствуют, либо встречаются весьма редко и не как основная рамка.[^9_3][^9_1]
2. **Смещение акцентов с государства на «обстоятельства»**
Учебники, по выводам Padgett (crit. case study), всё реже используют откровенно расистский язык, но **сохраняют колониальный и ассимиляционистский взгляд**:
    - подчеркивается «неизбежность» конфликта,
    - подача в духе «столкновения культур» и абстрактных «поселенцев», а не как сознательной политики государства.[^9_2]
3. **«Сбалансированность» там, где она неуместна**
Показательный (хотя британский, а не американский) пример — A‑level учебник *The Making of a Superpower: USA 1865–1975*, утверждённый экзаменационным советом AQA в Великобритании и затем отозванный. Учебник предлагал ученикам вопрос:
*«В какой степени, по вашему мнению, жестокое обращение с индейцами было преувеличено?»* — т.е. ставил под сомнение масштаб насилия, предлагая «сбалансировать» критику «защитой» политики США.[^9_13]
В США та же логика «объективации» присутствует в некоторых учебных материалах: геноцид и насильственное выселение обсуждаются как «спорный вопрос» или «сложное наследие», которое надо «увидеть с обеих сторон».[^9_14][^9_3]
4. **История останавливается «где‑то в XIX веке»**
Фрайберг (2024) показывает, что основные учебники и стандарты продолжают закреплять **«белую, санированную версию истории»**, где коренные народы существуют лишь как фигуры из далёкого прошлого; современный контекст (договорные права, резервации, борьба за воду, нефть и землю) не входит в массовый школьный нарратив.[^9_1]

***

## 3. Академическая и общественная критика учебников

### Независимые академические исследования

1. **Misrepresentation and Silence in United States History Textbooks**
Монография, проанализировавшая широкий корпус учебников, показывает:
    - систематическое **замалчивание геноцида** и структурного расизма;
    - внимание к «героической» истории США (экспансия, индустриализация) за счёт угнетённых групп;
    - представление коренных и мексикано‑американских народов как «проблемы» или «фонового элемента», а не полноправных исторических субъектов.[^9_3]
2. **Padgett, A Critical Case Study of Selected U.S. History Textbooks (2012 adoption)**
Исследование пяти школьных учебников выявило:
    - снижение прямой, открытой расистской лексики по сравнению с более старыми изданиями;
    - но при этом — **сохранение колониального сюжета**: прогресс ассоциируется с ассимиляцией индейцев или их «исчезновением», а коренные женщины почти полностью выпадают из повествования;
    - автор делает вывод: «колониализм и ассимиляция остаются базовой моделью изображения американских индейцев».[^9_2]
3. **Психологические последствия «омиссии» (Fryberg, 2024)**
Фрайберг рассматривает «Native omissions» — систематическое отсутствие современного присутствия индейцев в учебниках и публичной истории — как форму **символического стирания**. Это не просто недостаток информации, а важный механизм закрепления предубеждений: дети, и белые, и коренные, растут в картине мира, где индейцы — «люди прошлого», а не современные субъекты с правами.[^9_1]
4. **Критика с индейской стороны**
Статья American Indian College Fund (*Why Native Histories Matter in the Classroom*) фиксирует, что:
    - в школах часто преподаются неточные или стереотипные представления о коренных народах;
    - игнорирование реальной истории и современности делает школьную среду враждебной для индейских детей (расистские карикатуры, маскоты, упрощённые или ложные сюжеты в учебниках).[^9_15]

### Конкретные кейсы и политические конфликты

1. **Техас: этнические курсы и Native Studies**
    - В 2010‑е годы активисты и учёные добились одобрения курсов Mexican American Studies (2018) и African American Studies (2020) в Техасе.[^9_9][^9_10]
    - Попытка внедрить American Indian/Native Studies курс неоднократно откладывалась новым составом SBOE: в 2024 году голосование по общештатным стандартам для Native Studies вновь отложили, несмотря на поддержку учителей и общин.[^9_10][^9_11]
    - Консервативные члены совета и связанные с ними медиа критикуют такие программы как «woke», «CRT», «анти‑американские». Это прямой сигнал издателям и авторам: слишком честное освещение колониальной политики и геноцида может столкнуться с политическими санкциями.[^9_16][^9_12]
2. **Отклонённые учебники**
    - Пример учебника *Mexican American Heritage* (Техас): текст был отвергнут после критики историков (включая Американскую историческую ассоциацию) за расистские стереотипы — «мексиканцы ленивы», «чикано против западной цивилизации» и т.п..[^9_9]
    - Этот кейс показывает: если учебник слишком откровенно искажает историю, академическое сообщество способно давить на советы штатов, но **изначальная попытка протолкнуть подобный текст вполне реальна**.

***

## 4. Насколько США в 2026 году берут ответственность и просвещают школьников?

### Критерии оценки

Для оценки по шкале 1–100 можно условно смотреть на четыре измерения:

1. **Признание фактов**
— называются ли вещи своими именами (насильственное выселение, нарушенные договоры, этническая чистка, геноцид),
— присутствуют ли голоса самих коренных народов.
2. **Системность в школьной программе**
— есть ли это во всех штатах, во всех школах, а не только в «продвинутых» округах.
3. **Современность**
— показывается ли продолжение истории после 1900 года: договорные права, решения Верховного суда, борьба за землю и ресурсы.
4. **Цель «чтобы не повторилось»**
— подается ли это как моральный урок, с ясным указанием на ответственность государства, а не только как «сложный эпизод прошлого».

### Позитивные сдвиги

- Многие современные университетские и AP‑учебники (Brinkley и др.) значительно честнее, чем массовые школьные материалы 1970–1980‑х: колониализм, расизм и насильственное выселение больше нельзя полностью игнорировать.[^9_6][^9_5][^9_3]
- Растёт число элективных курсов по истории коренных народов, афро‑американской и мексикано‑американской истории; в ряде штатов их утвердили как часть стандартов.[^9_11][^9_10][^9_9]
- Серьёзные издательства стали отзывчивее к критике: пример с британским A‑level учебником по США, отозванным после возмущения по поводу вопроса про «преувеличение» страданий индейцев, показывает, что общественное давление может работать.[^9_13]
- В общенациональном дискурсе (за пределами школы) суды и федеральные структуры всё чаще признают исторические договорные права (дело *McGirt v. Oklahoma* и др.), что медленно просачивается и в учебные материалы.[^9_17][^9_18]


### Ограничения и откат

- Исследования показывают: **основной школьный мейнстрим по‑прежнему «белит» историю**, сводя коренных народов к до‑1900‑му эпизоду и не связывая прямым текстом прошлую политику с современным неравенством.[^9_3][^9_1][^9_2]
- Политические кампании против «Critical Race Theory» и «woke»‑курсов прямо нацелены на то, чтобы **ограничить честное обсуждение расизма и колониализма** в школах. Отложенные Native Studies в Техасе — яркий пример.[^9_12][^9_16][^9_10][^9_11]
- Во многих штатах любые формулировки, прямо называющие действия США «геноцидом» или «этнической чисткой», воспринимаются как «анти‑американские» и блокируются на уровне стандартов или школьных округов.[^9_16][^9_15][^9_1]


### Итоговая оценка (по шкале 1–100)

Если суммировать:

- Академическая историография (монографии, статьи, спецкурсы) в значительной степени **берёт на себя ответственность и называет вещи своими именами**. Там оценка могла бы быть на уровне 80–90/100.[^9_19][^9_1][^9_3]
- Однако **массовое школьное обучение** — крайне неоднородно:
    - в прогрессивных округах и некоторых штатах можно говорить о 60–70/100 (честное обсуждение, этнические курсы, участие самих общин в разработке программ);[^9_15][^9_11][^9_9]
    - в консервативных штатах, где идёт активная борьба против этнических и «критических» курсов, оценка скорее 10–30/100.[^9_12][^9_16][^9_10][^9_1]

Усредняя это по стране и учитывая, что большинство детей всё ещё получают **санитаризованную версию истории**, реалистичной выглядит оценка порядка:

> **≈ 40 из 100**

То есть:

- **ответственность частично признаётся** (сам факт жестокого обращения и массовой гибели коренных народов отрицается всё реже),
- **но систематическое, честное, структурное обсуждение причин и механизмов** (государственная политика, нарушенные договоры, идея «Manifest Destiny» как оправдание колониализма) по‑прежнему преподносятся в смягчённой и неполной форме,[^9_1][^9_2][^9_3]
- а политическое сопротивление попыткам включить более правдивый нарратив остаётся очень сильным.[^9_16][^9_10][^9_11][^9_15][^9_12]

Иными словами, в 2026 году США **ещё далеко** от того, чтобы на уровне массового школьного образования полноценно взять на себя ответственность за политику выселения и уничтожения коренных народов и превратить это в настоящий системный урок «чтобы такое больше не повторилось»; но движение в этом направлении есть и в академии, и в части школьных систем.

<div align="center">⁂</div>

[^9_1]: https://pmc.ncbi.nlm.nih.gov/articles/PMC11579633/

[^9_2]: https://nsuworks.nova.edu/cgi/viewcontent.cgi?article=2106\&context=tqr

[^9_3]: https://library.oapen.org/bitstream/id/01042e63-f305-478c-8d2d-90607d1122a6/978-3-031-50353-5.pdf

[^9_4]: https://www.mheducation.com/highered/discipline/history.html

[^9_5]: https://www.nas.org/storage/app/media/New Documents/History Textbooks.pdf

[^9_6]: https://www.mheducation.ca/higher-education/social-science-humanities/history-american-history

[^9_7]: https://info.mheducation.com/rs/128-SJW-347/images/NA-Social+Studies-6-8-United+States+History+Voices+and+Perspectives+Student+Edition+Topic+4+Sampler.pdf

[^9_8]: https://info.mheducation.com/rs/128-SJW-347/images/NA-Social+Studies-9-12-United+States+History+Student+Edition+Topic+14+Sampler.pdf

[^9_9]: https://www.historians.org/perspectives-article/a-textbook-case-texas-educators-fight-for-k-12-mexican-american-studies-december-2016/

[^9_10]: https://www.kut.org/education/2024-02-01/texas-state-board-of-education-american-indian-native-studies-curriculum-delayed-sboe

[^9_11]: https://www.texastribune.org/2024/04/01/texas-sboe-native-studies-course-delayed/

[^9_12]: https://www.texasobserver.org/abbott-appointee-slams-brakes-on-k-12-native-studies-course/

[^9_13]: https://www.bbc.com/news/education-59024961

[^9_14]: https://rethinkingschools.org/articles/lies-our-textbooks-tell-us/

[^9_15]: https://collegefund.org/blog/presidents-blog/why-native-histories-matter-in-the-classroom/

[^9_16]: https://dallasexpress.com/education/woke-history-texas-education-board-oks-native-american-elective-sparking-claims-of-crt-violations/

[^9_17]: https://www.zinnedproject.org/news/tdih/supreme-court-affirms-native-treaty-rights/

[^9_18]: https://www.supremecourt.gov/opinions/19pdf/18-9526_9okb.pdf

[^9_19]: https://digitalcommons.unl.edu/cgi/viewcontent.cgi?article=1001\&context=historydiss


---

# Понял. Уточни вот какой момент. Есть ли статистика в %, не зависимая желательно, сколько сейчас проживает коренных жителей на территории США? Ответь очень кратко в 2х предложениях.

По данным последней переписи населения США, численность коренных американцев (индейцев и коренных жителей Аляски) составляет около **2,9%** от всего населения страны (это около 9,7 миллиона человек, если считать тех, кто указал принадлежность как к одному, так и к нескольким этносам).[^10_7]

Если же учитывать только тех, кто идентифицирует себя **исключительно** как коренной американец (без смешения с другими расами), то их доля составляет около **0,7–1,6%** (примерно 2,5–5 миллионов человек).[^10_3][^10_5]
<span style="display:none">[^10_1][^10_10][^10_2][^10_4][^10_6][^10_8][^10_9]</span>

<div align="center">⁂</div>

[^10_1]: https://ru.wikipedia.org/wiki/Коренные_%D0%BD%D0%B0%D1%80%D0%BE%D0%B4%D1%8B_%D0%A1%D0%A8%D0%90

[^10_2]: https://americanbutler.ru/polezno/lifestyle/demographics

[^10_3]: https://ru.wikipedia.org/wiki/Население_%D0%A1%D0%A8%D0%90

[^10_4]: https://www.populationpyramid.net/ru/соединённые-штаты-америки/2026/

[^10_5]: https://interaffairs.ru/news/show/21935

[^10_6]: https://riamo.ru/articles/aktsenty/krah-beloj-ameriki-kak-izmenilsya-rasovyj-i-etnicheskij-sostav-ssha-za-poslednie-desyatiletiya/

[^10_7]: https://bespalov-finance.ru/media/articles/tpost/r89ol8zri1-naselenie-ssha-v-2025-godu

[^10_8]: https://countrymeters.info/ru/United_States_of_America_(USA)

[^10_9]: https://znanierussia.ru/articles/Список_%D1%88%D1%82%D0%B0%D1%82%D0%BE%D0%B2_%D0%B8_%D1%82%D0%B5%D1%80%D1%80%D0%B8%D1%82%D0%BE%D1%80%D0%B8%D0%B9_%D0%A1%D0%A8%D0%90_%D0%BF%D0%BE_%D1%87%D0%B8%D1%81%D0%BB%D0%B5%D0%BD%D0%BD%D0%BE%D1%81%D1%82%D0%B8_%D0%BD%D0%B0%D1%81%D0%B5%D0%BB%D0%B5%D0%BD%D0%B8%D1%8F

[^10_10]: https://ru.tradingeconomics.com/united-states/population


---

# Уточни, на 1803 год, ПРИМЕРНО, какое было соотношение? Тоже кратко, в 3х предложениях.

В 1803 году коренные народы всё ещё составляли значительную, хотя и трудно подсчитываемую точно часть населения континента, по разным оценкам достигая **15–20%** от общего населения Северной Америки (около 600 тысяч индейцев против 5–6 миллионов колонистов и рабов в США). Однако на конкретных западных землях, вроде приобретённой Луизианы, соотношение было обратным: там проживало около 50–100 тысяч белых поселенцев и рабов против сотен тысяч коренных жителей, то есть индейцы составляли там абсолютное большинство (до **80–90%**). Таким образом, если на востоке США коренное население уже стало меньшинством, то на присоединяемых западных территориях оно всё ещё доминировало демографически и фактически контролировало землю.[^11_1][^11_2][^11_3][^11_4][^11_5]

<div align="center">⁂</div>

[^11_1]: https://ru.wikipedia.org/wiki/Коренные_%D0%BD%D0%B0%D1%80%D0%BE%D0%B4%D1%8B_%D0%A1%D0%A8%D0%90

[^11_2]: https://ru.wikipedia.org/wiki/Население_%D0%A1%D0%A8%D0%90

[^11_3]: https://ru.wikipedia.org/wiki/Луизианская_%D0%BF%D0%BE%D0%BA%D1%83%D0%BF%D0%BA%D0%B0

[^11_4]: https://www.stena.ee/blog/“luizianskaya-pokupka”-1803-goda-cdelka-izmenivshaya-istoriyu-soedinyonnyh-shtatov

[^11_5]: https://ru.wikipedia.org/wiki/История_%D0%9B%D1%83%D0%B8%D0%B7%D0%B8%D0%B0%D0%BD%D1%8B

